{**********************************************************************
{*
{* BusyBox uWindow -- Version 3.0  (interface)
{*
{* Copyright (c)
{* Apple Computer, Inc.  1986-1989
{* All Rights Reserved.
{*
{* This file contains the interface to the code which implements  
{* windows in the busybox program.
{*
{**********************************************************************}

UNIT uWindow;

INTERFACE

USES

       types,
       GSOS,
       locator,
       quickdraw,
       fonts,
       MEMORY,
       intMath,
       events,
       controls,
       windows,
       lineedit,
       dialogs,
       menus,
       DESK,
       STDFILE,
	   resources,
       TextEdit,
       
       
       uGlobals,
       uUtils;

var
    TheMainWindow,
    ButtonsWindow,
    StatTextWindow,
    LineEditWindow,
    PicturesWindow,
    PopUpsWindow,
    TextEditWindow,
    ListsWindow         : GrafPortPtr;

procedure SetUpWindows;            {Initialize variables for stacking windows}
procedure DrawThisWindow;
procedure DoCloseTop;
procedure OpenThisWindow   (CtlID : integer);




IMPLEMENTATION

{$R-}

const	MainWindowID = $2000;


{**********************************************************************}
{
{ DrawThisWindow
{
{ This routine draws the contents of all the windows.
{
{*
{* Warning:  Do not make any calls that use the libraies or use
{* short addressing without setting the dbr to ~globals.
{*
{**********************************************************************}
procedure DrawThisWindow;
    begin
        DrawControls(GetPort);
    END;
    
{**********************************************************************}
{
{ DoCloseTop
{
{ This routine closes the topmost window.  We do a little work to
{ prevent the main window from being closed.
{
{**********************************************************************}
procedure DoCloseTop;
    var
        k : integer;
        TempWin : GrafPortPtr;
        
    begin
        { Get the front window into a local variable }
        TempWin := FrontWindow;
        
        { start the count at 1 since we never close the main window }
        k := 1;
        
        { Find the window entry, close the window, and zero the entry }
        repeat
        
            if TempWin = WindowList[k] then
                begin
                    CloseWindow(TempWin);
                    WindowList[k] := NIL;
                    k := NumWindows;
                end
            else
                k := k+1;
        until k >= NumWindows;      
    end;
    
{****************************************************************************}
{
{ OpenThisWindow
{
{ This routine either opens the specified window or brings it to the top
{ if it is already open.
{
{ If it is not open, we open it with NewWindow2 invisibly, adjust the window's
{ location and then show and select the window.
{
{ ID values for controls in the main window are assumed here to be from 1..n
{
{****************************************************************************}
procedure OpenThisWindow   (CtlID : integer);
    begin
        if WindowList[CtlID] = NIL then
            begin
                WindowList[CtlID] := NewWindow2(NIL,0,@DrawThisWindow,NIL,2,
                         Ref(POINTER(MainWindowID+CtlID)),rWindParam1);
                if CtlID < Prog1ID then 
                    begin
                        MoveWindow (50+8*StaggerCount,50+8*StaggerCount,WindowList[CtlID]);
                        StaggerCount := StaggerCount+1;
                    end;
                ShowWindow(WindowList[CtlID]);
                SelectWindow(WindowList[CtlID]);                
            end
        else SelectWindow(WindowList[CtlID]);
    end;
    
    
{*****************************************************************************}
{
{ SetUpWindows
{
{ Sets up WindowList record for use through out the program.
{
{*****************************************************************************}
procedure SetUpWindows;
    var
        k : integer;
        
    begin   {of SetUpWindows}
        { Zero out the entries in the window list. }
        for k := 0 to NumWindows-1 do WindowList[k] := NIL;
        
        { Open the main window }
        WindowList[0] := NewWindow2(NIL,0,@DrawThisWindow,NIL,2,ref(MainWindowID),
                               rWindParam1);
    end;    {of SetUpWindows}
    



END.
